/* Rev Jul 11 2013 MS Initial version */
/* Rev Sep 11 2013 SM Added mode verfication after mode transition,  */
/*                    added comments and deleted unused functions */
/* Rev Oct 08 2013 SM Re-organized code and minor code changes */
/* Rev Nov 13 2013 SM Replaced "while" with "if" clause in mode verification */
/* Rev Jan 29 2015 SM Removed code: writes to SC_DC3, SC_DC4 (caused IVOR1)  */
/*                    & changed PLLCAL3, init order of PREDIV, MFD, RFDPHI */

#include "project.h"

void PLL_160MHz(void)
{
  /* Connect XOSC to PLL. We ultimately use the output of PLL1. PLL1 must be fed the output of PLL0 */
  CGM.AC3_SC.B.SELCTL = 1; //40 MHz XOSC selected as input of PLL0

  CGM.AC4_SC.B.SELCTL= 0; //PLL0_PHI1 selected as input of PHI1

  /* Configure PLL0 Dividers - 160MHz from 40Mhx XOSC */
  /* PLL input = FXOSC = 40MHz
     VCO range = 600-1200MHz
  */

  /* Configure PLL0 to 160 MHz. */
  PLLDIG.PLL0DV.B.RFDPHI1 = 4;
  PLLDIG.PLL0DV.B.RFDPHI = 4;
  PLLDIG.PLL0DV.B.PREDIV  = 1;
  PLLDIG.PLL0DV.B.MFD     = 16;

  /* Program PLL1 to same frequency as PLL0.
   * MFD multiplies input by at least 10. So multiply by 10 and divide by 10.
   * 10/10 = 1, so same frequency as PLL0
   */
  PLLDIG.PLL1DV.B.RFDPHI = 10;
  PLLDIG.PLL1DV.B.MFD = 10;

  /* switch to PLL */
  MC_ME.DRUN_MC.R = 0x00130072;
  MC_ME.MCTL.R = 0x30005AF0;
  MC_ME.MCTL.R = 0x3000A50F;
  while(MC_ME.GS.B.S_MTRANS == 1);      /* Wait for mode transition complete */
}

void system160mhz(void)
{
  /* SYS_CLK Divide */
  CGM.SC_DC0.B.DIV = 3;  /* Freq = sysclk / (3+1) = sysclk */
  CGM.SC_DC0.B.DE  = 1;  /* Enable divided clock */

  /* LIN_CLK Divide */
  CGM.AC13_SC.B.SELCTL = 0b010; //PLL0_PHI_CLK is source of LIN_CLK
  CGM.AC13_DC0.R = 0x80010000;	//Divide by (1+1) for 80 MHz LIN_CLK

  PLL_160MHz();
}

void enter_STOP_mode (void) {
  MC_ME.MCTL.R = 0xA0005AF0;      /* Enter STOP mode and key */
  MC_ME.MCTL.R = 0xA000A50F;      /* Enter STOP mode and inverted key */
  while (MC_ME.GS.B.S_MTRANS) {}  /* Wait for STOP mode transition to complete */
}
